/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.ammo;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SimpleMaterial
implements IAmmoMaterial {
    private final ResourceLocation materialID;
    private final ITextComponent displayName;
    private final Integer tracer;
    private final int textColor;
    private final int defaultLevelRequirement;

    SimpleMaterial(ResourceLocation materialID, int textColor, int defaultLevelRequirement, Integer tracer) {
        this.materialID = materialID;
        this.textColor = textColor;
        this.tracer = tracer;
        this.defaultLevelRequirement = defaultLevelRequirement;
        this.displayName = new TranslationTextComponent(this.convertID(materialID));
    }

    @Override
    public ResourceLocation getMaterialID() {
        return this.materialID;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public Integer getTracerColor() {
        return this.tracer;
    }

    @Override
    public int getTextColor() {
        return this.textColor;
    }

    @Override
    public int defaultLevelRequirement() {
        return this.defaultLevelRequirement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMaterial that = (SimpleMaterial)o;
        return this.materialID.equals((Object)that.materialID);
    }

    public int hashCode() {
        return this.materialID.hashCode();
    }

    private String convertID(ResourceLocation location) {
        String loc = location.toString().replaceAll(":", ".");
        return "ammo.material." + loc;
    }
}

